/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

public class ObjectDumperAttributes {
    public static final boolean OBJECTS = true;
    public static final boolean NO_OBJECTS = false;
    public static final boolean ARRAYS = true;
    public static final boolean NO_ARRAYS = false;
    public static final boolean SUPERCLASSES = true;
    public static final boolean NO_SUPERCLASSES = false;
    public static final boolean PUBLIC = true;
    public static final boolean NO_PUBLIC = false;
    public static final boolean PROTECTED = true;
    public static final boolean NO_PROTECTED = false;
    public static final boolean PACKAGE_PRIVATE = true;
    public static final boolean NO_PACKAGE_PRIVATE = false;
    public static final boolean PRIVATE = true;
    public static final boolean NO_PRIVATE = false;
    public static final boolean STATIC = true;
    public static final boolean NO_STATIC = false;
    public static final boolean FINAL = true;
    public static final boolean NO_FINAL = false;
    public static final boolean TRANSIENT = true;
    public static final boolean NO_TRANSIENT = false;
    public static final boolean VOLATILE = true;
    public static final boolean NO_VOLATILE = false;
    public static final ObjectDumperAttributes DEFAULT = new ObjectDumperAttributes();
    static final short OBJECTS_ATTR = 1;
    static final short ARRAYS_ATTR = 2;
    static final short SUPERCLASSES_ATTR = 4;
    static final short PUBLIC_ATTR = 8;
    static final short PROTECTED_ATTR = 16;
    static final short PACKAGE_PRIVATE_ATTR = 32;
    static final short PRIVATE_ATTR = 64;
    static final short STATIC_ATTR = 128;
    static final short FINAL_ATTR = 256;
    static final short TRANSIENT_ATTR = 512;
    static final short VOLATILE_ATTR = 1024;
    static final short DEFAULT_ATTRS = 1791;
    int maxLevel;
    short attribs;

    public ObjectDumperAttributes(int maxLevel, boolean expandObjects, boolean expandArrays, boolean dumpSuperclasses, boolean dumpPublic, boolean dumpProtected, boolean dumpPackagePrivate, boolean dumpPrivate, boolean dumpStatic, boolean dumpFinal, boolean dumpTransient, boolean dumpVolatile) {
        this.maxLevel = maxLevel;
        this.attribs = 0;
        if (expandObjects) {
            this.attribs = (short)(this.attribs | 1);
        }
        if (expandArrays) {
            this.attribs = (short)(this.attribs | 2);
        }
        if (dumpSuperclasses) {
            this.attribs = (short)(this.attribs | 4);
        }
        if (dumpPublic) {
            this.attribs = (short)(this.attribs | 8);
        }
        if (dumpProtected) {
            this.attribs = (short)(this.attribs | 0x10);
        }
        if (dumpPackagePrivate) {
            this.attribs = (short)(this.attribs | 0x20);
        }
        if (dumpPrivate) {
            this.attribs = (short)(this.attribs | 0x40);
        }
        if (dumpStatic) {
            this.attribs = (short)(this.attribs | 0x80);
        }
        if (dumpFinal) {
            this.attribs = (short)(this.attribs | 0x100);
        }
        if (dumpTransient) {
            this.attribs = (short)(this.attribs | 0x200);
        }
        if (dumpVolatile) {
            this.attribs = (short)(this.attribs | 0x400);
        }
    }

    public ObjectDumperAttributes(int maxLevel, boolean expandObjects, boolean expandArrays) {
        this();
        this.maxLevel = maxLevel;
        this.attribs = (short)(this.attribs & 1);
        if (expandObjects) {
            this.attribs = (short)(this.attribs | 1);
        }
        this.attribs = (short)(this.attribs & 2);
        if (expandArrays) {
            this.attribs = (short)(this.attribs | 2);
        }
    }

    public ObjectDumperAttributes(int maxLevel) {
        this();
        this.maxLevel = maxLevel;
    }

    public ObjectDumperAttributes() {
        this.maxLevel = 2;
        this.attribs = (short)1791;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isExpandObjects() {
        return (this.attribs & 1) != 0;
    }

    public boolean isExpandArrays() {
        return (this.attribs & 2) != 0;
    }

    public boolean isDumpSuperclasses() {
        return (this.attribs & 4) != 0;
    }

    public boolean isDumpPublic() {
        return (this.attribs & 8) != 0;
    }

    public boolean isDumpProtected() {
        return (this.attribs & 0x10) != 0;
    }

    public boolean isDumpPackagePrivate() {
        return (this.attribs & 0x20) != 0;
    }

    public boolean isDumpPrivate() {
        return (this.attribs & 0x40) != 0;
    }

    public boolean isDumpStatic() {
        return (this.attribs & 0x80) != 0;
    }

    public boolean isDumpFinal() {
        return (this.attribs & 0x100) != 0;
    }

    public boolean isDumpTransient() {
        return (this.attribs & 0x200) != 0;
    }

    public boolean isDumpVolatile() {
        return (this.attribs & 0x400) != 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[').append(this.getMaxLevel()).append(',').append(this.isExpandObjects() ? "Obj" : "~Obj").append(',').append(this.isExpandArrays() ? "Arr" : "~Arr").append(',').append(this.isDumpSuperclasses() ? "Sup" : "~Sup").append(',').append(this.isDumpPublic() ? "Pub" : "~Pub").append(',').append(this.isDumpProtected() ? "Pro" : "~Pro").append(',').append(this.isDumpPackagePrivate() ? "Pkg" : "~Pgk").append(',').append(this.isDumpPrivate() ? "Prv" : "~Prv").append(',').append(this.isDumpStatic() ? "Sta" : "~Sta").append(',').append(this.isDumpFinal() ? "Fin" : "~Fin").append(',').append(this.isDumpTransient() ? "Tra" : "~Tra").append(',').append(this.isDumpVolatile() ? "Vol" : "~Vol").append(']');
        return result.toString();
    }

    ObjectDumperAttributes(int maxLevel, short attribs) {
        this.maxLevel = maxLevel;
        this.attribs = attribs;
    }
}

